{include file="orderforms/standard_cart/common.tpl"}

<div id="order-standard_cart">
    <div class="row">
        <div class="cart-sidebar">
            {include file="orderforms/standard_cart/sidebar-categories.tpl"}
        </div>
        <div class="cart-body">

            <div class="header-lined">
                <h1 class="font-size-36">
                    {if $productGroup.headline}
                        {$productGroup.headline}
                    {else}
                        {$productGroup.name}
                    {/if}
                </h1>
                {if $productGroup.tagline}
                    <p>{$productGroup.tagline}</p>
                {/if}
            </div>
            {if $errormessage}
                <div class="alert alert-danger">
                    {$errormessage}
                </div>
            {elseif !$productGroup}
                <div class="alert alert-info">
                    {lang key='orderForm.selectCategory'}
                </div>
            {/if}

            {include file="orderforms/standard_cart/sidebar-categories-collapsed.tpl"}
natix
            <div class="products natix-cart" id="products">
                <div class="row row-eq-height">
                    {foreach $products as $key => $product}

                    <div class="col-lg-6 col-md-12 col-sm-12" id="product{$product@iteration} ">
                    <div class="plan p-xl-5 p-lg-5 p-md-5 p-sm-5 p-4 mt-xl-0 mt-lg-0 mt-md-5 mt-sm-4 mt-4 mb-lg-5">
                        {* <div class="hosting-text">20% Discount</div> *}
                        <figure class="hosting-img-1 float-xl-none float-lg-none float-md-left float-sm-left">
                            <img src="{$WEB_ROOT}/templates/{$template}/assets/images/package-{$product.name}.png" alt="">
                        </figure>
                        <h4 class="mb-xl-4 mb-lg-4 mb-md-4 mb-sm-2">
                         <span id="product{$product@iteration}-name">{$product.name}</span>
                                {if $product.stockControlEnabled}
                                    <span class="qty">
                                            {$product.qty} {$LANG.orderavailable}
                                        </span>
                                {/if}
                        
                        </h4>
                        <p class="mb-xl-4 mb-lg-4 mb-md-4 mb-sm-4">Lorem ipsum dolor sit amet, conse tetur adipiscing elit.</p>

                         {if $product.featuresdesc}
                                    <p id="product{$product@iteration}-description">
                                        {$product.featuresdesc}
                                    </p>
                                {/if}
                                <ul>
                                    {foreach $product.features as $feature => $value}
                                        <li id="product{$product@iteration}-feature{$value@iteration}">
                                            <span class="feature-value">{$value}</span>
                                            {$feature}
                                        </li>
                                    {/foreach}
                                </ul>
                        {*
                        <ul class="list-unstyled float-xl-none float-lg-none float-md-left float-sm-left mb-xl-0 mb-lg-3 mb-sm-0">
                            <li><figure class="float-left"> <img src="{$WEB_ROOT}/templates/{$template}/assets/images/hosting-disk-icon.png" alt="Disk Space"></figure><span class="specs pl-xl-3 pl-lg-3 pl-md-3 pl-sm-3 pl-3">Disk Space</span><span class="weightage float-right">250 GB</span></li>
                            <li><figure class="float-left"> <img src="{$WEB_ROOT}/templates/{$template}/assets/images/hosting-bandwidth-icon.png" alt="Data Bandwidth"></figure><span class="specs pl-xl-3 pl-lg-3 pl-md-3 pl-sm-3 pl-3">Data Bandwidth</span><span class="weightage float-right">1 TB</span></li>
                            <li><figure class="float-left"> <img src="{$WEB_ROOT}/templates/{$template}/assets/images/hosting-email-icon.png" alt="Email Accounts"></figure><span class="specs pl-xl-3 pl-lg-3 pl-md-3 pl-sm-3 pl-3">Email Accounts</span><span class="weightage float-right">120</span></li>
                            <li><figure class="float-left"> <img src="{$WEB_ROOT}/templates/{$template}/assets/images/hosting-domain-icon.png" alt="LTDâ€™s Domains"></figure><span class="specs pl-xl-3 pl-lg-3 pl-md-3 pl-sm-3 pl-3">LTDâ€™s Domains</span><span class="weightage float-right">50</span></li>
                        </ul> *}
                        <div class="pt-xl-3">
                           <small>Starting at:</small>
                           <div class="hosting-pricing">
                             <div class="product-pricing" id="product{$product@iteration}-price">
                                    {if $product.bid}
                                        {$LANG.bundledeal}<br />
                                        {if $product.displayprice}
                                            <span class="price">{$product.displayprice}</span>
                                        {/if}
                                    {else}
                                        {if $product.pricing.hasconfigoptions}
                                            {$LANG.startingfrom}
                                            <br />
                                        {/if}
                                        <span class="price">{$product.pricing.minprice.price}</span>
                                        <br />
                                        {if $product.pricing.minprice.cycle eq "monthly"}
                                            {$LANG.orderpaymenttermmonthly}
                                        {elseif $product.pricing.minprice.cycle eq "quarterly"}
                                            {$LANG.orderpaymenttermquarterly}
                                        {elseif $product.pricing.minprice.cycle eq "semiannually"}
                                            {$LANG.orderpaymenttermsemiannually}
                                        {elseif $product.pricing.minprice.cycle eq "annually"}
                                            {$LANG.orderpaymenttermannually}
                                        {elseif $product.pricing.minprice.cycle eq "biennially"}
                                            {$LANG.orderpaymenttermbiennially}
                                        {elseif $product.pricing.minprice.cycle eq "triennially"}
                                            {$LANG.orderpaymenttermtriennially}
                                        {/if}
                                        <br>
                                        {if $product.pricing.minprice.setupFee}
                                            <small>{$product.pricing.minprice.setupFee->toPrefixed()} {$LANG.ordersetupfee}</small>
                                        {/if}
                                    {/if}
                                </div>
                           </div>
                           <div class="hosting-button pt-xl-3 pt-lg-3 pt-md-3 pt-sm-2">
                            <a href="{$WEB_ROOT}/cart.php?a=add&{if $product.bid}bid={$product.bid}{else}pid={$product.pid}{/if}" class="btn btn-success btn-sm" id="product{$product@iteration}-order-button">
                                    <i class="fas fa-shopping-cart"></i>
                                    {$LANG.ordernowbutton}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>





                    
                    {if $product@iteration % 2 == 0}
                </div>
                <div class="row row-eq-height">
                    {/if}
                    {/foreach}
                </div>
            </div>
        </div>
    </div>
</div>
